/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.ce.casehandlers;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWParameter;
import filenet.vw.api.VWStepElement;
import java.util.HashMap;

public class StepElementDataEx {
    private HashMap<String, String> m_dataFieldsMap = null;
    private HashMap<String, StepElementParameter> m_parametersMap = null;
    private String m_selectedResponse = null;
    private String[] m_stepResponses = null;
    private VWStepElement m_stepElement = null;

    public StepElementDataEx(String workObjectNumber, String workflowName) {
        this.m_dataFieldsMap = new HashMap();
        this.m_dataFieldsMap.put("F_WobNum", workObjectNumber);
        this.m_dataFieldsMap.put("F_WorkflowName", workflowName);
        this.m_parametersMap = new HashMap();
    }

    protected StepElementDataEx(VWStepElement stepElement) throws VWException {
        int i;
        this.m_stepElement = stepElement;
        this.m_dataFieldsMap = new HashMap();
        this.m_dataFieldsMap.put("F_WobNum", stepElement.getWorkObjectNumber());
        this.m_dataFieldsMap.put("F_WorkflowName", stepElement.getWorkflowName());
        this.m_dataFieldsMap.put("F_Comment", stepElement.getComment());
        this.m_dataFieldsMap.put("F_Subject", stepElement.getSubject());
        this.m_stepResponses = stepElement.getStepResponses();
        this.m_parametersMap = new HashMap();
        VWParameter[] stepParams = stepElement.getParameters(63, 1);
        if (stepParams != null) {
            for (i = 0; i < stepParams.length; ++i) {
                this.m_parametersMap.put(stepParams[i].getName(), new StepElementParameter(stepParams[i]));
            }
        }
        if ((stepParams = stepElement.getParameters(64, 3)) != null) {
            for (i = 0; i < stepParams.length; ++i) {
                this.m_parametersMap.put(stepParams[i].getName(), new StepElementParameter(stepParams[i]));
            }
        }
    }

    public VWStepElement getStepElement() {
        return this.m_stepElement;
    }

    public String getComment() {
        return this.m_dataFieldsMap.get("F_Comment");
    }

    public void setComment(String comment) {
        this.m_dataFieldsMap.put("F_Comment", comment);
    }

    public String getSubject() {
        return this.m_dataFieldsMap.get("F_Subject");
    }

    public void setSubject(String subject) {
        this.m_dataFieldsMap.put("F_Subject", subject);
    }

    public String[] getStepResponses() {
        String[] responses = null;
        if (this.m_stepResponses != null) {
            responses = new String[this.m_stepResponses.length];
            System.arraycopy(this.m_stepResponses, 0, responses, 0, responses.length);
        }
        return responses;
    }

    public String getSelectedResponse() {
        return this.m_selectedResponse;
    }

    public void setSelectedResponse(String selectedResponse) throws VWException {
        if (selectedResponse == null || selectedResponse.length() == 0) {
            throw new VWException("filenet.pe.ce.casehandlers.StepElementDataEx.NullResponse", "The response can not be null or empty.");
        }
        boolean bFound = false;
        if (this.m_stepResponses != null) {
            for (int i = 0; i < this.m_stepResponses.length; ++i) {
                if (!this.m_stepResponses[i].equals(selectedResponse)) continue;
                bFound = true;
                break;
            }
            if (!bFound) {
                throw new VWException("filenet.pe.ce.casehandlers.StepElementDataEx.InvalidResponse", "The response \"{0}\" is not valid.", selectedResponse);
            }
        }
        this.m_selectedResponse = selectedResponse;
    }

    public String getWorkflowName() {
        return this.m_dataFieldsMap.get("F_WorkflowName");
    }

    public String getWorkObjectNumber() {
        return this.m_dataFieldsMap.get("F_WobNum");
    }

    public StepElementParameter getParameter(String parameterName) {
        StepElementParameter stepParameter = null;
        if (this.m_parametersMap != null && this.m_parametersMap.containsKey(parameterName)) {
            stepParameter = this.m_parametersMap.get(parameterName);
        }
        return stepParameter;
    }

    public String[] getParameterNames() {
        String[] names = null;
        if (this.m_parametersMap != null) {
            names = this.m_parametersMap.keySet().toArray(new String[0]);
        }
        return names;
    }

    public StepElementParameter[] getParameters() {
        StepElementParameter[] stepParameters = null;
        if (this.m_parametersMap != null) {
            stepParameters = this.m_parametersMap.values().toArray(new StepElementParameter[0]);
        }
        return stepParameters;
    }

    public Object getParameterValue(String parameterName) {
        Object parameterValue = null;
        StepElementParameter stepParameter = this.getParameter(parameterName);
        if (stepParameter != null) {
            parameterValue = stepParameter.getValue();
        }
        return parameterValue;
    }

    public void setParameterValue(String parameterName, Object newParameterValue) throws VWException {
        StepElementParameter stepParameter = this.getParameter(parameterName);
        if (stepParameter == null) {
            stepParameter = new StepElementParameter(parameterName, newParameterValue);
            this.m_parametersMap.put(parameterName, stepParameter);
        } else {
            stepParameter.setValue(newParameterValue);
        }
    }

    public static class StepElementParameter {
        private String m_name;
        private int m_mode = -1;
        private int m_type = -1;
        private Object m_value;

        protected StepElementParameter(VWParameter vwParameter) throws VWException {
            this.m_name = vwParameter.getName();
            this.m_mode = vwParameter.getMode();
            this.m_type = vwParameter.getFieldType();
            this.m_value = vwParameter.getValue();
        }

        public StepElementParameter(String parameterName, Object parameterValue) throws VWException {
            this.m_name = parameterName;
            this.setValue(parameterValue);
        }

        public String getName() {
            return this.m_name;
        }

        public int getMode() {
            return this.m_mode;
        }

        public int getType() {
            return this.m_type;
        }

        public boolean isArray() {
            boolean isArray = false;
            if (this.m_value != null) {
                isArray = this.m_value.getClass().isArray();
            }
            return isArray;
        }

        public Object getValue() {
            return this.m_value;
        }

        public void setValue(Object newValue) throws VWException {
            if (newValue == null) {
                throw new VWException("filenet.pe.ce.casehandlers.StepElementParameter.NullValueNotSupported", "Null values are not supported.");
            }
            int newType = VWFieldType.getVWFieldType(newValue);
            if (newType == -1) {
                throw new VWException("filenet.pe.ce.casehandlers.StepElementParameter.InvalidType", "Object is not a supported type.");
            }
            if (this.m_type != -1 && newType != this.m_type) {
                throw new VWException("filenet.pe.ce.casehandlers.StepElementParameter.WrongType", "Object type \"{0}\" does not match expected parameter type \"{1}\".", newType, this.m_type);
            }
            this.m_type = newType;
            this.m_value = newValue;
        }
    }
}

